#L_06_04.py
#Circumference
import numpy as np
import scipy.integrate as integral
from numdifftools import Derivative
r=1  #radius
#r=sqrt(x^2+y^2)
def f(x):
    return np.sqrt(r**2-x**2)
'''
#self-defined function for testing
def derivative(f,x,h=1e-9):
    return (f(x+h)-f(x-h))/(2.0*h)

def dl(x):
    return np.sqrt(1.0+derivative(f,x)**2)
'''
#numdifftools
def dl(x): 
    df=Derivative(f,method='complex')
    return np.sqrt(1.0+df(x)**2)
#distances
a=-r
b=r
#Circumference
U1=2.0*r*np.pi #exactly
U2=2.0*integral.quad(dl,a,b)[0]
print("Circumference exactly:   ",U1)
print("Circumference integrated:",U2)
print("Absolute error: ",U1-U2)
