#L_06_05.py
#Spherical volume, spherical surface as a body of revolution
import numpy as np
import scipy.integrate as integral
from numdifftools import Derivative
r=1
def f(x):
    return np.sqrt(r**2-x**2)
#Square function
def f2(x):
    return f(x)**2

def m(x):
    df=Derivative(f)
    return f(x)*np.sqrt(1+df(x)**2)
#limits
a=-r
b=r
#volume
V1=4/3*r**3*np.pi #exactly
V2=np.pi*integral.quad(f2,a,b)[0]
#surface
A1=4*np.pi*r**2 #exactly
A2=2*np.pi*integral.quad(m,a,b)[0]
print("-------------Volume--------")
print("Sphere volume exactly      :",V1)
print("Integrated spherical volume:",V2)
print("Absolute error: ",V1-V2)
print("-------------Surface-----")
print("Spherical surface exactly   :",A1)
print("Integrated spherical surface:",A2)
print("Absolute error: ",A1-A2)

