#L_06_10.py
#Comparison of exponential and logistic growth
import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import solve_ivp
K=100  #Capacity
r=0.5  #Growth rate    
b=r/K
tmax=24
y0=[1] #Initial value
#exponentielles Wachstum
def dgl1(t,y0,r):
    N = y0   
    dN_dt=r*N
    return dN_dt
#logistical growth
def dgl2(t,y0,r,b):
    N = y0   
    dN_dt=r*N-b*N**2
    return dN_dt

t = np.linspace(0,tmax,500)
z1=solve_ivp(dgl1,[0,tmax],y0,args=(r,),dense_output=True)
z2=solve_ivp(dgl2,[0,tmax],y0,args=(r,b),dense_output=True)
N1 = z1.sol(t).flatten()
N2 = z2.sol(t).flatten()
fig,axes=plt.subplots(2,1,figsize=(6,6))
#exponential growth
axes[0].plot(t, N1,"r-",lw=2)
axes[0].set(xlabel="Time",ylabel="Number",title="Exponential growth")
axes[0].grid(True)
#logistical growth
axes[1].plot(t, N2,"b-",lw=2)
axes[1].set(xlabel="Time",ylabel="Number",title="Logistical growth")
axes[1].grid(True)
fig.tight_layout()
plt.show()
