#L_06_11.py
#Spring pendulum with phase diagram
import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import solve_ivp
m=0.5   #mass 
d=0.2   #damping
c= 5    #spring constant N/m
ya=0.1  #deflection in m
#ODE
def dgl(t,y0,D,w02):
    y,v=y0
    dy_dt=v
    dv_dt=-D*v-w02*y
    return [dy_dt,dv_dt]
#Calculations
w02=c/m
D=d/m
#ODE solution
y0=[ya,0] #Initial value
t=np.linspace(0,10,500)
z=solve_ivp(dgl,[0,10],y0,args=(D,w02),dense_output=True)
y,v=z.sol(t)
#Grafikbereich
fig, ax=plt.subplots(3,figsize=(6,9))
#deflection
ax[0].plot(t,y)
ax[0].set(xlabel='t',ylabel='y',title='Deflection')
#velocity
ax[1].plot(t,v)
ax[1].set(xlabel='t',ylabel='v',title='Velocity')
#phase diagram
ax[2].plot(y,v)
ax[2].set(xlabel='y',ylabel='v',title='Phase diagram')
fig.tight_layout()
plt.show()
