##L_06_12.py
#Simulation of the Foucault pendulum
import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import solve_ivp
l=67           #length of the pendulum in m
d=1.896        #diameter of the sphere in dm
auslenkung=2   #deflection in m
cw=0.3         #drag coefficient for sphere
rho_K=7.85     #density of steel kg/dm^2
rho_L=1.28     #density of air kg/m^3
g=9.81         #acceleration due to gravity
tmax=50
#ODE-System
def dgl(t,ya,b,w02):
    phi, w = ya
    dphi_dt = w
    dw_dt = -b*np.abs(w)*w-w02*np.sin(phi)
    return [dphi_dt,dw_dt]
#Calculations
phi0=np.arcsin(auslenkung/l) #deflection angle
r=d/2                        #radius of the sphere in dm
A=np.pi*(0.1*r)**2           #circular area in m^2
m=rho_K*(4/3)*np.pi*r**3     #mass of the sphere in kg
b=cw*rho_L*A*l/(2*m)         #damping constant
w02=g/l
T=2.0*np.pi*np.sqrt(l/g)
f=1.0/T    #Frequenz
vmax=np.sqrt(2*g*l*(1-np.cos(phi0)))
#Lösung der DGL
y0 = [phi0,0]
t = np.linspace(0, tmax, 500)
z=solve_ivp(dgl,[0,tmax],y0,args=(b,w02),dense_output=True)
phi, w = z.sol(t) 
x= l*np.sin(phi)
y=l-l*np.cos(phi)
v=l*w
#output
fig,ax=plt.subplots(2,2,figsize=(12,8))
#deflection
ax[0,0].plot(t, x,'r-',lw=2)
ax[0,0].set(ylabel="Deflection in m",title="Deflection")
#velocity
ax[1,0].plot(t, v,'b-',lw=2)
ax[1,0].set(xlabel='Time in s',ylabel="v in m/s",title='Velocity')
#trajectory
ax[0,1].plot(x, y,'k-',lw=1)
#ax[0,1].set_xticks([-2,0,2])
ax[0,1].set(xlabel='x in m',ylabel="y in m",title='Trajectory')
#phase diagram
ax[1,1].plot(x, v,'g-',lw=1)
ax[1,1].set(xlabel='x',ylabel="v in m/s",title="Phase diagram")
fig.tight_layout()
print("Deflection angle %2.2f in °" %np.degrees(phi0))
print("Mass of the sphere %3.2f kg"%m)
print("Period duration %3.2f s"%T)
print("Frequency %3.2f Hz"%f)
print("Damping %3.4f"%b)
print("maximum velocity %3.2f m/s"%vmax)
plt.show()

'''
#Foucaultsches Pendel 
d=1.896
l=67
phi=1.71 
'''



