#L_06_13.py
#coupled thread pendulum
import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import solve_ivp
#data
g = 9.81    #acceleration due to gravity
l= 0.2      #pendulum lengths
m= 0.2      #pendulum masses
c=1         #spring constant
tmax=20
#ODE-System
def dgl(t,ya,l, m, c):
    phi1,w1,phi2,w2 = ya
    phi1_dt=w1
    w1_dt=-g/l*phi1-c/m*(phi1-phi2)
    phi2_dt=w2
    w2_dt=-g/l*phi2+c/m*(phi1-phi2)
    return [phi1_dt, w1_dt, phi2_dt, w2_dt]
#initial values
phi1 = 3
phi2 = 6
omega1 = omega2 = 0
ya =[np.radians(phi1),omega1,np.radians(phi2),omega2]
t = np.linspace(0,tmax,1000)
#solution of the ODE system
z=solve_ivp(dgl,[0,tmax],ya,args=(l,m,c),dense_output=True)
phi1,w1,phi2,w2 = z.sol(t)
deflection1,deflection2 = np.degrees(phi1),np.degrees(phi2)
#create objects for two subdiagrams
fig,ax=plt.subplots(2,1,figsize=(6,9))
#deflection l1
ax[0].set_title("Pendulum 1")
ax[0].plot(t,deflection1,"r",lw=2)
ax[0].set_ylabel(r"$\varphi_{1}$")
ax[0].grid(True)
#deflection l2
ax[1].set_title("Pendulum 2")
ax[1].plot(t,deflection2,'b',lw=2)
ax[1].set_xlabel("Time")
ax[1].set_ylabel(r"$\varphi_{2}$")
ax[1].grid(True)
fig.tight_layout()
plt.show()
'''
Quelle für DGL-System
Ahrens S. 1052
'''


