#L_06_17.py
#SIRD-model from theoretical biology
import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import solve_ivp
tmax=120
#initial values
S0=997     #non-immune healthy people
I0=3       #Infected
R0=0       #Recovered people
D0=0       #Deaths
N=S0+I0+R0 #population
#parameter
a=0.4   #Infection rate
g=0.035 #Recovery rate
m=0.005 #Mortality rate
#ODE-System
def dgl(t,ya):
    S,I,R,D=ya
    dS_dt=-a*S*I/N        #non-immune healthy people
    dI_dt=a*S*I/N-g*I-m*I #Infected
    dR_dt=g*I             #Recovered people
    dD_dt=m*I
    return [dS_dt,dI_dt,dR_dt,dD_dt]
#initial values
y0 = [S0,I0,R0,D0]
ti=[0,tmax]
t = np.linspace(0, tmax, 500)
z=solve_ivp(dgl,ti,y0,dense_output=True)
S,I,R,D = z.sol(t)
#create two objects
fig,ax = plt.subplots(figsize=(8,6))
ax.plot(t, S,'b',lw=2,label="Healthy people")
ax.plot(t, I,'r',lw=2,label="Infected")
ax.plot(t, R,'g',lw=2,label="Recovered people")
ax.plot(t, D,'k',lw=2,label="Deaths")
ax.legend(loc="best")
ax.set_xlabel("Time")
ax.set_ylabel("Individuals",color="red")
ax.grid(True)
plt.show()




