#L_06_18.py
#THD for half-wave rectification
import numpy as np
import matplotlib.pylab as plt
from scipy.fft import fft,fftfreq  
f=50     #frequency in Hz
T=1./f   #period duration
N=6000   #number of samples
Ta=T/N   #sampling time
t=np.linspace(0,T,N)
#Calculate harmonic distortion
def thd(u):
    z=0
    for i in range(1,len(u)):
        z=z+u[i]**2  
    return np.sqrt(z)/u[0]   

@np.vectorize
def ug(t):
    umax=10
    if t < T/2:
        return umax*np.sin(2*np.pi*f*t)
    else:
        return 0

u_t=ug(t)
#transformation into the frequency domain
U_fft = fft(u_t)
#absolute values of the amplitudes in the frequency domain
U_f=2*np.abs(U_fft)/N
#calculate harmonics
fk=fftfreq(N,Ta)
pos=np.where(fk>0) #only positive frequencies
print("Harmonic distortion %2.3f"%thd(U_f[pos]))
fig,ax=plt.subplots(2,1,figsize=(6,6))
#represent square wave voltage
ax[0].plot(1e3*t,u_t,"b-",lw=2)
ax[0].grid(True)
ax[0].set_xlabel("Time in ms");
ax[0].set_ylabel("Voltage in V",color="blue")
#represent frequency spectrum
ax[1].stem(fk[pos],U_f[pos])
ax[1].grid(True)
ax[1].set_xlabel("Frequency f in Hz")
ax[1].set_ylabel("Amplitudes")
ax[1].set_xlim(0,1000)
fig.tight_layout()
plt.show()

