#L_06_20.py
#Frequency response for 3rd degree Butterworth bandstop
import numpy as np
import matplotlib.pyplot as plt
from scipy import signal
fu=50  #lower limit frequency in Hz
fo=500 #upper limit frequency in Hz
g=3    #Degree of band stop
b, a = signal.butter(g,[fu,fo],'bandstop',analog=True)
f, h = signal.freqs(b,a)
#output
fig,ax = plt.subplots()
ax.semilogx(f,20*np.log10(abs(h)))
ax.set_title('Band-stop filter')
ax.set_xlabel('f in Hz')
ax.set_ylabel('Amplitude [dB]')
ax.set_ylim(-20,3)
ax.margins(0, 0.1)
ax.grid(which='both', axis='both')
plt.show()