#12_ball_wall.py
from vpython import *
scene.width=scene.height=600
scene.background=color.white
cw=color.gray(0.9) #color of the walls
b = 5.0 #width
d = 0.3 #thickness of the wall
r=0.4   #ball radius
s2 = 2*b - d
s3 = 2*b + d
#right hand wall
box (pos=vec(b, 0, 0), size=vec(d, s2, s3), color = cw)
#left hand wall
box (pos=vec(-b, 0, 0), size=vec(d, s2, s3), color = cw)
#bottom wall
box (pos=vec(0, -b, 0), size=vec(s3, d, s3), color = cw)
#top wall
box (pos=vec(0, b, 0), size=vec(s3, d, s3), color = cw)
#back wall
box(pos=vec(0, 0, -b), size=vec(s2, s2, d), color = cw)
ball = sphere(radius=r,color=color.yellow)
ball.m = 2.0 #mass of the ball
ball.p = vec(-0.15, -0.23, 0.27) #impulse
#ball.p = vec(0,-1,0)
#ball.p = vec(-1,0,0)
#ball.p = vec(0,-1,-1)
b = b - d*0.5 - ball.radius
dt = 0.2
while True:
    rate(100)
    ball.pos = ball.pos + (ball.p/ball.m)*dt
    if not (b > ball.pos.x > -b):
        ball.p.x = -ball.p.x
    if not (b > ball.pos.y > -b):
        ball.p.y = -ball.p.y
    if not (b > ball.pos.z > -b):
        ball.p.z = -ball.p.z
