#14_elliptical_orbit.py
from vpython import *
scene.width=600
scene.height=600
b=10.     #semiaxis of the ellipse
a=1.157*b #semiaxis of the ellipse
Rm=1.     #Moon radius
Re=3.7*Rm #Earth radius
rem=10.*Re #Earth-Moon distance
scene.background=color.white
earth = sphere(pos=vector(0.1*a,0,0),radius=Re,texture=textures.earth)
moon = sphere(pos=vector(rem,0,0),radius=Rm,color=color.gray(0.8))
w=1.0 #angular velocity
t=0
dt=1e-3
while  True:
    rate(100)
    x = a*cos(w*t)
    y = b*sin(w*t)
    moon.pos = vector(x,y,0)
    t=t+dt
