#18_pendulum.py
from vpython import *
y0=-5.  #shift on the y-axis
b=5.    #width of the ceiling
l=8.    #length of the pendulum
phi=45. #deflection
r=0.5   #radius of the sphere
scene.width=600
scene.height=600
scene.center =vector(0,y0,0)
scene.range=1.5*b
scene.background = color.white
box(size=vector(b,b/20.,b/2.),color=color.gray(0.8)) #ceiling
rod=cylinder(axis=vector(0,l,0),radius=0.05)
mass = sphere(radius=r,color=color.red)
mass.pos=vector(0,rod.pos.y,0)
g=9.81   #gravitational acceleration
w02=g/l  #square of the angular frequency
phi=radians(phi) 
w=0.  #initial angular velocity
dt=0.02
while True:
    rate(100)
    phi=phi+w*dt
    w=w-w02*sin(phi)*dt
    x= l*sin(phi)
    y=-l*cos(phi)
    rod.axis=vector(x,y,0)
    mass.pos=vector(x,y,0)
