#19_spring_pendulum.py
from vpython import *
y0=-5. #shift on the y-acis
b=8.   #width of the ceiling
l=0.8*y0 #length of the spring
r=1.2  #radius of the mass
c=1.1  #spring constant
m=1.5  #mass of the sphere
scene.width=600
scene.height=600
scene.center =vector(0,y0,0)
scene.background = color.white
box(pos=vector(0,b/40.,0),size=vector(b,b/20.,b/2.),
color=color.gray(0.8)) #ceiling
spring=helix(axis=vector(0,l,0),radius=0.6,color=color.yellow)
spring.thickness=0.2
spring.coils=8
mass=sphere(pos=spring.pos,radius=r,color=color.red)
w02=c/m   #square of the angular frequency
y=-0.6*l  #deflection
v=0.      #initial velocity
dt=0.02
while True:
    rate(100)
    y=y+v*dt
    v=v-w02*y*dt
    spring.axis=vector(0,y+l,0)
    mass.pos =vector(0,y+l-r,0)
