#21_double_spring_pendulum.py
from vpython import *
y0=-5. #shift on the y-axis
b=10.  #width of the ceiling
r=1.2  #radius of the mass
l=0.9*y0
c1=1.  #spring constant
m1=1.  #mass of the sphere
c2=1.
m2=1.
scene.width=600
scene.height=800
scene.center =vector(0,2*y0,0)
scene.background = color.white
box(pos=vector(0,b/40.,0),size=vector(b,b/20.,b/2.),
color=color.gray(0.8)) #ceiling
spring1 = helix(pos=vector(0,0,0),axis=vector(0,l,0),
               color=color.yellow,radius=0.5*r,thickness=0.2,coils=10)
mass1 = sphere(pos=spring1.pos,radius=r, color=color.red)
spring2 = helix(pos=vector(0,l,0),axis=vector(0,l,0),
               color=color.green,radius=0.5*r,thickness=0.2,coils=10)
mass2 = sphere(pos=vector(0,2*l,0),radius=r, color=color.blue)
y1=-0.6*l #deflection
y2=0
v1=v2=0   #initial velocity
lk=l-r
dt=0.02
while True:
    rate(50)
    y1=y1 + v1*dt
    v1=v1-(c1+c2)/m1*y1*dt+c2/m1*y2*dt #-0.05*v1*dt
    y2=y2 + v2*dt
    v2=v2-c2/m2*(y2-y1)*dt #-0.05*v2*dt
    spring1.axis=vector(0,y1+l,0)
    mass1.pos =vector(0,y1+lk,0)
    spring2.axis=vector(0,y1+y2+l,0)
    spring2.pos.y =mass1.pos.y
    mass2.pos =spring2.pos+vector(0,y1+y2+lk,0)
