#22_double_pendulum.py
from vpython import *
phi1=radians(-5.)
phi2=radians(5.)
b=12.   #width of the ceiling
y0=-b/2.#shift on the y-axis
a=b/2.  #distance between the pendulums
l=0.9*b #length of the pendulums
r=b/15. #radius of the spheres
m=10.   #mass of the spheres
c=4.5   #spring constant
scene.width=600
scene.height=600
scene.center=vector(0,y0,0)
scene.range=0.8*b
scene.background = color.white
box(size=vector(b,b/20.,b/4.),color=color.gray(0.8)) #ceiling
rod1=cylinder(axis=vector(0,l,0),radius=0.05)
rod1.pos=vector(-a/2.,0,0)
rod2=cylinder(axis=vector(0,l,0),radius=0.05)
rod2.pos=vector(a/2.,0,0)
mass1 = sphere(radius=r,color=color.red)
mass2 = sphere(radius=r,color=color.blue)
spring=helix(axis=vector(a,0,0),radius=0.4)
spring.thickness=0.1
spring.coils=10
g=9.81   #gravitational acceleration
w02=g/l  #pendulum frequency
k=c/m    #spring frequency
w1=w2=0  #angular velocity
dt=0.02
while True:
    rate(100)
    phi1=phi1+w1*dt
    w1=w1-w02*phi1*dt+k*(phi2-phi1)*dt #-0.05*w1*dt
    phi2=phi2+w2*dt
    w2=w2-w02*phi1*dt-k*(phi2-phi1)*dt #-0.05*w2*dt
    x1= l*sin(phi1)
    y1=-l*cos(phi1)
    x2= l*sin(phi2)
    y2=-l*cos(phi2)
    rod1.axis=vector(x1,y1,0)
    mass1.pos =vector(x1-a/2.,y1,0)
    rod2.axis=vector(x2,y2,0)
    mass2.pos =vector(x2+a/2.,y2,0)
    spring.pos=mass1.pos+vector(r,0,0)
    spring.axis.x=x2-x1+a-2*r
    spring.axis.y=y2-y1
