#08_05.py
import numpy as np
U1=10    #Input voltage
I1=10e-3 #Input current
f=1e3    #frequency in kHz
l=1      #line length in km
R=60     #loop resistance
L=0.6e-3 #loop inductance
G=1e-6   #insulator conductance
C=50e-9  #insulator capacitance
#calculations
w=2*np.pi*f
Zw=np.sqrt((R+1j*w*L)/(G+1j*w*C))
g=np.sqrt((R+1j*w*L)*(G+1j*w*C))
U2=    np.cosh(g*l)*U1 - Zw*np.sinh(g*l)*I1
I2=-np.sinh(g*l)/Zw*U1 +   np.cosh(g*l)*I1
Z2=U2/I2
#output
print("Line length:",l, "km")
print("Wave resistance: %5.2f\u03A9, %5.1f°"\
      %(np.abs(Zw),np.angle(Zw,deg=True)))
print("Load resistance  : %5.2f\u03A9, %5.1f°"\
      %(np.abs(Z2),np.angle(Z2,deg=True)))
print("Output voltage: %5.2f V, %5.1f°"\
      %(np.abs(U2),np.angle(U2,deg=True)))
print("Output current   : %5.2f A, %5.1f°"\
      %(np.abs(I2),np.angle(I2,deg=True)))




