#05_tally_sheet.py
import numpy as np
values=np.loadtxt("data.txt")
n=len(values)
k=int(np.sqrt(n)+0.5)
minimum=np.amin(values)
maximum=np.amax(values)
R=round(maximum-minimum,2)
w=round(R/k,2)
svalues=np.sort(values)
H,I=np.histogram(values, bins=k)
h=100*H/n
print("Measurement values:\n",svalues)
print("Minimum value:", minimum)
print("Maximum value:", maximum)
print("Span:",R)
print("Number of classes:", k)
print("Class interval:", w)
print("Ranges:", np.around(I,decimals=2))
print("Absolute frequency:", H)
print("Relative frequency:", h,"%")
print("Number of measurement values:", sum(H))
