#09_stdaw.py
import numpy as np
import statistics as st
import time as t
n=100000
setpoint=100
s=2
def stdaw(values):
    n=len(values)
    sum=0
    for i in range(n):
        sum=sum+values[i]
        mean=sum/n
    sum_rq=0
    for i in range(n):
        sum_rq=sum_rq+(values[i]-mean)**2
    v=sum_rq/(n-1) #variance
    return np.sqrt(v)

#values=[1,2,3,4,5,6]
values=np.random.normal(setpoint,s,size=n)
t1=t.time()
s1=stdaw(values)
t2=t.time()
s2=st.stdev(values)
t3=t.time()
s3=np.std(values,ddof=1) 
t4=t.time()
print("\t\t  Standard deviation","Time",sep=2*("\t"))
print("Custom version  :",s1,t2-t1)
print("Python version  :",s2,t3-t2)
print("NumPy version   :",s3,t4-t3)
