#10_mcapability.py
import numpy as np
setpoint=50
To=5
Tu=-5
T=To-Tu
values = np.loadtxt("data.txt")
m=np.mean(values)
s=np.std(values,ddof=1)
Cm=T/(6*s)
UCL=setpoint+To #Upper control limit
LCL=setpoint+Tu #Lower control limit
delta_o=UCL-m
delta_u=m-LCL
if delta_o > delta_u:
    delta_k=delta_u
else:
    delta_k=delta_o
Cmk=delta_k/(3*s)
print("Mean:",m)
print("Standard deviation:",s)
print("Machine capability index: ",Cm)
print("Machine capability characteristic value:",Cmk)
