#13_skew.py
import numpy as np
from scipy import stats
n=50
setpoint=50
s=2
values=np.random.normal(setpoint,s,size=n)
rvalues=np.around(values,decimals=2)
mode=stats.mode(rvalues, axis=None)
mw=np.mean(rvalues)
md=np.median(rvalues)
stabw=np.std(rvalues,ddof=1)
S1=(mw-md)/stabw
S2=stats.skew(rvalues)
print(np.sort(rvalues))
print("Mode:        ",mode)
print("Mean:        ",mw)
print("Median:      ",md)
print("Standard deviation:",stabw)
print("Skew (approximation):",S1)
print("Skew (exact):   ",S2)
if S2<0:
    print("right-skewed")
else:
    print("left-skewed") 
