#16_qrt_table.py
import numpy as np
rows=5
columns=10
A3=1.152
B4=1.669
values = np.loadtxt("data.txt")
n=len(values)
table=np.reshape(values,(rows,columns),order='F')
mw=[]
staw=[]
for i in range(columns):
    sum1=0
    sum2=0
    for j in range(rows):
        sum1=sum1+table[j,i]
        mean=sum1/rows
    for j in range(rows):    
        sum2=sum2+(mean-table[j,i])**2
        standardabw=np.sqrt(sum2/(rows-1))
    mw.append(round(mean,2))
    staw.append(round(standardabw,3))
mmw=np.mean(mw)
mws=np.mean(staw)
UCLm=mmw + A3*mws  #Upper control limit
LCLm=mmw - A3*mws  #Lower control limit
UCLs=B4*mws
print("Table of measurement values:\n",table)
print("Mean value of the samples:")    
print(mw)
print("Standard deviation of the samples:")
print(staw)
print("Mean value chart")
print("Upper intervention limit:",UCLm)
print("Lower intervention limit:",LCLm)
print("Standard deviation chart")
print("Upper intervention limit:",UCLs)
