#17_qrt_graphics.py
import numpy as np
import matplotlib.pyplot as plt
rows=5
columns=10
A3=1.152
B4=1.669
values = np.loadtxt("data.txt")
n=len(values)
table=np.reshape(values,(rows,columns),order='F')
h=np.linspace(1,columns,columns)
mw=[]
staw=[]
for i in range(columns):
    mw.append(round(np.mean(table[0:rows,i]),2))
    staw.append(round(np.std(table[0:rows,i],ddof=1),3))
mmw=np.mean(mw)
mws=np.mean(staw)
UCLm=mmw+A3*mws  #Upper control limit
LCLm=mmw-A3*mws  #Lower control limit
UCLs=B4*mws
x=[1,columns]
y1=[UCLm,UCLm]
y2=[mmw,mmw]
y3=[LCLm,LCLm]
y4=[UCLs,UCLs]
fig, ax = plt.subplots(2, 1)
ax[0].set_title("Mean value chart")
ax[0].plot(x,y1,'r-')
ax[0].plot(x,y2,'g-')
ax[0].plot(x,y3,'r-')
ax[0].plot(h,mw,'bx-')
ax[0].set_ylabel("Mean")
ax[1].set_title("Standard deviation chart")
ax[1].plot(x,y4,'r-')
ax[1].plot(h,staw,'gx-')
ax[1].set_xlabel("Samples")
ax[1].set_ylabel("s")
fig.tight_layout()
plt.show()

'''
fig.savefig("/Users/veit/documents/Python_Ing/2_Auflage/pictures_usa/09_005.pdf")
fig.savefig("/Users/veit/documents/Python_Ing/2_Auflage/pictures_usa/09_005.svg")
'''
