#L_09_03.py
import time as t
import numpy as np
import statistics as st
import scipy.stats as stats

n=100000
target_value=100
s=1 #standard deviation

def stdaw(values):
    n=len(values)
    s=0 #sum
    sum_rq=0
    for i in range(n):
        s=s + values[i]
        sum_rq=sum_rq + values[i]**2    
    mean=s/n
    v=(sum_rq - n*mean**2)/(n-1)
    return np.sqrt(v)   
    
#values=[1,2,3,4,5]
values=target_value + s*np.random.normal(size=n)
t1=t.time()
s1=stdaw(values)          #eigene
t2=t.time()
s2=st.stdev(values)       #Python
t3=t.time()
s3=np.std(values,ddof=1)  #NumpPy
t4=t.time()
s4=stats.tstd(values)     #SciPy
t5=t.time()
#Ausgaben
print("\t\tStandard deviation","Time",sep=("\t"))
print("My version    :",s1,t2-t1)
print("Python version:",s2,t3-t2)
print("NumPy  version:",s3,t4-t3)
print("SciPy  version:",s4,t5-t4)



