#02_gui_pack.py
import tkinter as tk
#calculation of the moment of inertia    
def moment_of_inertia():
    pi=3.14159
    rho=7.85 #kg/dm^3
    d = float(txtDiameter.get())#dm
    l = float(txtLength.get())     #dm
    try:
        J = rho*l*pi*d**4/32
        J = ('{0:6.2f}'.format(1e-2*J)) #kgm^2
        lblResult["text"] = "J=" + str(J) + " kgm^2"
    except:
        lblResult["text"]= "Enter numbers"
#graphics area
main = tk.Tk()
main.minsize(400,200)
main.title("Moment of inertia of a cylinder")
#create label
lblDiameter=tk.Label(main, text="Enter diameter in dm")
lblLength=tk.Label(main, text="Enter length in dm")
lblResult = tk.Label(main,text="")
#create text fields
txtDiameter=tk.Entry(main, width=5,justify="right")
txtDiameter.insert(5, "0.8")
txtLength = tk.Entry(main,width=5, justify="right")
txtLength.insert(5,"10")
#create command buttons
cmdCompute=tk.Button(main, text="Compute", command=moment_of_inertia)
cmdExit=tk.Button(main, text="Exit", command=main.destroy)
#insert controls
lblDiameter.pack()
txtDiameter.pack()
lblLength.pack()
txtLength.pack()
cmdCompute.pack()
lblResult.pack()
cmdExit.pack()
main.mainloop()
