#03_gui_grid.py
import tkinter as tk
#function for moment of inertia
def moment_of_inertia():
    pi=3.14159
    rho=7.85  #kg/dm^3
    d = float(txtDiameter.get()) #dm
    l = float(txtLength.get())   #dm
    try:
        J = rho*l*pi*d**4/32
        J = ('{0:6.2f}'.format(1e-2*J)) #kgm^2
        lblResult["text"] = str(J) + " kgm^2"
    except:
        lblResult["text"]= "Enter numbers"
#graphics area
main = tk.Tk()
main.minsize(400,115)
main.title("Moment of inertia of a cylinder")
lblDiameter=tk.Label(main, text="Enter diameter in dm")
lblLength=tk.Label(main, text="Enter length in dm")
lblMoment_of_inertia = tk.Label(main,text="Moment of inertia")
lblResult = tk.Label(main,text="")
txtDiameter=tk.Entry(main, justify="right")
txtDiameter.insert(2,"0.8")
txtLength = tk.Entry(main, justify="right")
txtLength.insert(2,"10")
cmdCompute=tk.Button(main, text="Compute",command=moment_of_inertia)
cmdExit=tk.Button(main, text="Exit", command=main.destroy)
lblDiameter.grid(row=0,column=0,sticky="w")
txtDiameter.grid(row=0,column=1,sticky="e")
lblLength.grid(row=1,column=0,sticky="w")
txtLength.grid(row=1,column=1,sticky="e")
lblMoment_of_inertia.grid(row=2,column=0,sticky="w")
lblResult.grid(row=2,column=1,sticky="e")
cmdCompute.grid(row=3,column=0)
cmdExit.grid(row=3,column=1)
main.mainloop()
