#05_slider.py
import tkinter as tk
main=tk.Tk()
#moment of inertia   
def moment_of_inertia(self):
    pi=3.14159
    rho=7.85 #Density of steel kg/dm^3
    l=10     #Length of the cylinder in dm
    d=sldD.get() #Diameter in mm
    d=1e-2*d #Conversion to dm
    J = rho*l*pi*d**4/32 #in kgdm^2
    J=('{0:5.3f}'.format(1e-2*J))  #Conversion to m
    lblD["text"] = "J=" + str(J) + " kgm^2"
#generate slider object
sldD=tk.Scale(main, width=20, length=400,
              from_= 50, to= 200,  #range in mm
              orient='horizontal',
              resolution=1,        #resolution in mm
              tickinterval=25, 
              label="d in mm",    
              command=moment_of_inertia, #function call
              font=("Arial 14"))    
#graphics area
main.minsize(500,110)
main.title("Moment of inertia of a cylinder")
lblD=tk.Label(main,text="J=",font=("Arial 14"))
sldD.set(80) #set initial value
lblD.pack()
sldD.pack()
main.mainloop() 
