#10_pid_controller.py
import tkinter as tk
main = tk.Tk()
main.title("Step response of P, PI and PID controllers")
xmax, ymax = 800,400
select=tk.StringVar()
select.set("PID")
canZ = tk.Canvas(width=xmax, height=ymax, bg='white')

def delete():
    return canZ.delete("all")

def controller():
    tmax=400
    Kp=50
    Tn=50
    Tv=50
    e=1
    t=ui=e0=ur=0
    dt=2
    sx=xmax/tmax
    u2_t = []
    while t<=tmax:       
        up = Kp*e            #P controller
        ui = ui + Kp*e*dt/Tn #PI controller
        ud = Kp*Tv*(e-e0)/dt #PD controller
        e0=e            
        t=t+dt
        if select.get()=="P":     ur=up
        elif select.get()=="PI":  ur= up+ui
        elif select.get()=="PID": ur=up+ui+ud
        u2_t.append(sx*t)
        u2_t.append(int(-ur) + ymax)  
    canZ.create_line(u2_t, fill='blue', width=2)
optP=tk.Radiobutton(main,text="P controller",variable=select,value="P")
optPI=tk.Radiobutton(main,text="PI controller",variable=select,value="PI")
optPID=tk.Radiobutton(main,text="PID controller",variable=select,value="PID")
cmdStart = tk.Button(main,text="Run",command=controller)
cmdNeu=tk.Button(main,text="New",command=delete)
canZ.pack()
optP.pack(side="left")
optPI.pack(side="left")
optPID.pack(side="left")
cmdStart.pack(side="left")
cmdNeu.pack(side="left")
main.mainloop()
