#differenzenquotient.py
import numpy as np
import matplotlib.pyplot as plt
T=1         #Periodendauer
w=2*np.pi/T #Kreisfrequenz
#zentraler Differenzenquotient
def diff(f,x,h=1e-3):
    return (f(x+h)-f(x-h))/(2*h)
#Sinus-Funktion
def f1(t):
    return np.sin(w*t) 
#erste Ableitung
def f2(t):
    return diff(f1,t)
#Grafikbereich
fig,ax = plt.subplots(2,1)
t = np.linspace(0,T,500) 
ax[0].plot(t, f1(t), 'b-', lw=1.2)
ax[1].plot(t, f2(t), 'r-', lw=1.2)
#Beschriftungen
ax[0].set_ylabel('$y$')
ax[1].set(xlabel='$t$',ylabel=r'$\dot{y}$',title='1. Ableitung')
fig.tight_layout()
plt.show()


'''
#Lösung für die Übung
import numpy as np
import matplotlib.pyplot as plt
T=1         #Periodendauer
w=2*np.pi/T #Kreisfrequenz
#zentraler Differenzenquotient
def diff(f,x,h=1e-3):
    return (f(x+h)-f(x-h))/(2*h)
#Sinus-Funktion
def f1(t):
    return np.sin(w*t) 
#erste Ableitung
def f2(t):
    return diff(f1,t)
#zweite ableitung
def f3(t):
    return diff(f2,t)
#Grafikbereich
fig,ax = plt.subplots(3,1)
t = np.linspace(0,T,500) 
ax[0].plot(t, f1(t), 'b-', lw=1.2)
ax[1].plot(t, f2(t), 'r-', lw=1.2)
ax[2].plot(t, f3(t), 'g-', lw=1.2)
#Beschriftungen
ax[0].set_ylabel('$y$')
ax[1].set(xlabel='$t$',ylabel=r'$\dot{y}$',title='1. Ableitung')
fig.tight_layout()
plt.show()
'''