#sld_phasenverschiebung.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider
T=1           #Periodendauer
w=2*np.pi/T   #Kreisfrequenz in rad/s
xmax,ymax=T,2  
#Slider abfragen
def update(val):
    phi = np.radians(sldPhi.val)
    y = np.sin(w*t + phi)
    txtPhi.set_text(r'$\varphi$ = %2.2f rad' %phi)
    linie.set_data(t,y)
#Grafikbereich
fig, ax = plt.subplots(label="Phasenverschiebung")
fig.subplots_adjust(left=0.12,bottom=0.18)
t=np.linspace(0,T,500)
ax.axis([0,xmax,-ymax,ymax])
linie, = ax.plot(t,np.sin(w*t),'r-')
#Slider-Steuerelement
#left, bottom, width, height
xyPhi=fig.add_axes([0.09, 0.02, 0.82, 0.03])
dicKnopf={'size':'12','facecolor':'red'}
sldPhi=Slider(xyPhi,r'$\varphi$ in °',-90,90,valinit=0,valstep=0.1,handle_style=dicKnopf)
sldPhi.on_changed(update)
#Ausgabe des Phasenverschiebungswinkels in rad
txtPhi=ax.text(0.8*T/2,1.05*ymax, r'$\varphi$ = %2.2f rad' %0)
ax.set(xlabel='$t$',ylabel='$y$')
ax.grid() #erzeugt Gitternetzlinien
plt.show()

#Listing 1.14

# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_01-NF005.svg")
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_01-NF005.pdf")


