#02_001.py
#Kräftezerlegung
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.patches import FancyArrowPatch,ArrowStyle
Fx=np.array([4,0])
Fy=np.array([0,3])
F=Fx+Fy
Fb=np.hypot(Fx[0],Fy[1])
alpha=np.arctan(Fx[0]/Fy[1])
alpha=np.degrees(alpha)
fig, ax = plt.subplots(label='Kräftezerlegung')
ax.axis([-1,5,-1,4])
#Vektoren
spitze = ArrowStyle.Simple(head_length=10,head_width=6,tail_width=1)
vFx=FancyArrowPatch((0,0),Fx,color='red',arrowstyle=spitze)
vFy=FancyArrowPatch((0,0),Fy,color='red',arrowstyle=spitze)
vF=FancyArrowPatch((0,0),F,color='red',arrowstyle=spitze)
ax.add_patch(vFx)
ax.add_patch(vFy)
ax.add_patch(vF)
#Beschriftungen
ax.text(-0.3,2.7,'$F_{y}$',fontsize=12)
ax.text(3.5,-0.33,'$F_{x}$',fontsize=12)
ax.text(2.4,2.1,r'$F$ = %0.1f N' %Fb,fontsize=12,rotation=33)
ax.text(1.0,0.4,r'$\alpha$ = %0.1f °' %alpha,fontsize=12)
ax.set(xlabel='${x}$',ylabel='${y}$')
ax.grid()
plt.show()
'''
fig.savefig("/Users/veit/documents/Python_Physik/Abbildungen/02_001.png")
fig.savefig("/Users/veit/documents/Python_Physik/Abbildungen/02_001.svg")
'''