#L_02_01.py
'''
Drei Kraftvektoren werden geometrisch addiert.
'''
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.patches import FancyArrowPatch,ArrowStyle
#Komponenetn der Kraftvektoren
Fx1,Fy1 = 2,4
Fx2,Fy2 = 4,4
Fx3,Fy3 = 6,0
F1=np.array([Fx1,Fy1])
F2=np.array([Fx2,Fy2])
F3=np.array([Fx3,Fy3])
Fr=F1+F2+F3
#Grafikbereich
fig, ax=plt.subplots(figsize=(8,8),label="Komponenten eines Kraftvektors")
fig.subplots_adjust(left=0.12,bottom=0.18)
ax.axis([-1,15,-2,10])
#Kraftvektoren definieren
LW=2
SP = ArrowStyle.Simple(head_length=10,head_width=5)
vecF1=FancyArrowPatch((0,0),F1,color='r',arrowstyle=SP,lw=LW)
vecF2=FancyArrowPatch(F1,F2+F1,color='g',arrowstyle=SP, lw=LW)
vecF3=FancyArrowPatch(F2+F1,F3+F2+F1,color='b',arrowstyle=SP,lw=LW)
vecFr=FancyArrowPatch((0,0),Fr,color='black',arrowstyle=SP,lw=LW)
#Pfeile zeichnen
ax.add_patch(vecF1)
ax.add_patch(vecF2)
ax.add_patch(vecF3)
ax.add_patch(vecFr)
#Beschriftungen
ax.text(0.6,2.7,'$F_{1}$')
ax.text(3.4,6.5,'$F_{2}$')
ax.text(8.5,8.5,'$F_{3}$')
ax.text(7.5,4.4,'$F_{res}$')
ax.set(xlabel='$F_{x}$ in N',ylabel='$F_{y}$ in N')
ax.set_title('$F_{res}$ = (%2.2f, %2.2f) N' %(Fr[0],Fr[1]))
ax.grid()
plt.show()


'''
#Alternative
ax.quiver(Fx1,Fy1,color='r',angles='xy',scale_units='xy', scale=1)
ax.quiver(Fx1,Fy1,Fx2,Fy2,color='g',angles='xy',scale_units='xy', scale=1)
ax.quiver(Fx2+Fx1,Fy2+Fy1,Fx3,Fy3,color='b',angles='xy',scale_units='xy', scale=1)
ax.quiver(0,0,Fr[0],Fr[1],color='k',angles='xy',scale_units='xy', scale=1)

'''






