#L_02_02.py
'''
Ein Kraftvektor wird in seine x- und y-Komponente zerlegt
'''
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.patches import FancyArrowPatch,ArrowStyle
from matplotlib.widgets import Slider
#Daten
F=10    #Kraft in N
alpha0=np.pi/4
#Slider abfragen
def update(val):
    winkel = sldAlpha.val
    alpha=np.radians(winkel)
    Fx=F*np.cos(alpha) #x-Komponente des Kraftvektors
    Fy=F*np.sin(alpha) #y-Komponente des Kraftvektors
    txtFx.set_text('$F_{x}$ = %.2f N' %Fx)
    txtFy.set_text('$F_{y}$ = %.2f N' %Fy)
    vecFx.set_positions([0,0],[Fx,0])
    vecFy.set_positions([0,0],[0,Fy])
    vecF.set_positions((0,0),(Fx,Fy))
#Grafikbereich
fig, ax=plt.subplots(figsize=(8,8),label="Komponenten eines Kraftvektors")
fig.subplots_adjust(left=0.12,bottom=0.18)
ax.axis([-1.2*F,1.2*F,-1.2*F,1.2*F])
#Kraftvektoren
SP = ArrowStyle.Simple(head_length=18,head_width=8)
vecF =  FancyArrowPatch((0,0),(F*np.cos(alpha0),F*np.sin(alpha0)),color='blue',arrowstyle=SP)
vecFx = FancyArrowPatch((0,0),(F*np.cos(alpha0),0),color='red',arrowstyle=SP)
vecFy = FancyArrowPatch((0,0),(0,F*np.sin(alpha0)),color='red',arrowstyle=SP)
ax.add_patch(vecF)
ax.add_patch(vecFx)
ax.add_patch(vecFy)
#platzieren der Textelemente
txtFx=ax.text(-50,100,'$F_{x}$ = %.2f N' %50) #y-Komponente der Kraft
txtFy=ax.text( 50,100,'$F_{y}$ = %.2f N' %50) #y-Komponente der Kraft
#Slider
xyAlpha=fig.add_axes([0.1, 0.02, 0.75, 0.03])
sldAlpha=Slider(xyAlpha,r'$\alpha$ in °',0,360,valinit=45,valstep=0.1)
sldAlpha.on_changed(update)
#ax.axis('off')
ax.set_aspect('equal')
ax.set_title('Betrag des Kraftvektors $F$ = %.2f N' %F)
ax.grid()
plt.show()

'''
fig.savefig("/Users/veit/documents/Python_Physik/Abbildungen/02_005.png")
fig.savefig("/Users/veit/documents/Python_Physik/Abbildungen/02_005.svg")
'''






