#L_02_04.py
#Drehmoment mit wirksamen Hebelarm
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.patches import FancyArrowPatch,ArrowStyle
from matplotlib.widgets import Slider
l = 1    #Länge des Hebels in m
F=100    #Kraft in  N
#Slider abfragen
def update(val):
    winkel = sldAlpha.val
    alpha=np.radians(winkel)
    beta=np.pi/2-alpha
    x=l*np.cos(beta)
    y=-l*np.sin(beta)
    lw=l*np.sin(alpha)
    M=F*lw
    txtAlpha.set_text('%.f °' %winkel)
    txtAlpha.set(x=x-0.1,y=y+0.25)
    txtFy.set_text('$F$ = %.1f N' %F)
    txtFy.set(x=x,y=y + 0.5)
    txtM.set_text('$M$ = %.1f Nm' %M)
    txtLw.set_text('$l_{w}$ = %.2f m' %lw)
    txtLw.set(x=x-0.5,y=y - 0.1)
    hebel.set_data([0,x],[0,y])
    lx.set_data([0,x],[y,y])
    ly.set_data([0,0],[0,y])
    pfeilF.set_positions((x, y+0.5),(x,y))
#Grafikbereich
fig, ax=plt.subplots(figsize=(8,8),label="Drehmoment")
fig.subplots_adjust(left=0.12,bottom=0.18)
ax.axis([-0.04,1.2*l,-0.9*l,0.5*l])
ax.plot(0,0,'ko',markersize=14)
hebel, = ax.plot([0,0.5],[0,-0.866],'k-',lw=8)#Hebelarm
lx,= ax.plot([0,0.5],[-0.866,-0.866],'k--',lw=1.5)
ly,= ax.plot([0,0],[0,-0.866],'k--',lw=1.5)
spitze = ArrowStyle.Simple(head_length=18,head_width=8)
#Kraft
pfeilF = FancyArrowPatch((0.5,-0.4),(0.5,-0.866),color='red',arrowstyle=spitze,url='Hallo')
#ax.add_patch(pfeilH)
ax.add_patch(pfeilF)
#platzieren der Textelemente
txtLw=ax.text(0.1,-0.95,'$l_{w}$ = %.2f  m' %0.5)
txtM=ax.text(0,0.06,'$M$ = %.1f Nm' %50)
txtFy=ax.text(0.5,-0.4,'$F$ = %.1f N' %F)
txtAlpha=ax.text(0.42,-0.65,'%.0f °'%30)
#Slider
xyAlpha=fig.add_axes([0.1, 0.02, 0.75, 0.03])
sldAlpha=Slider(xyAlpha,r'$\alpha$ in °',30,90,valinit=30,valstep=0.1)
sldAlpha.on_changed(update)
ax.axis('off')
ax.set_aspect('equal')
ax.set_title('Länge des Hebelarms $l$ = %.2f m' %l)
plt.show()

'''
fig.savefig("/Users/veit/documents/Python_Physik/Abbildungen/02_005.png")
fig.savefig("/Users/veit/documents/Python_Physik/Abbildungen/02_005.svg")
'''






