#sld_auflagekraefte.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.patches import FancyArrowPatch,ArrowStyle
from matplotlib.widgets import Slider
F=1000    #Last in  N
l= 5      #Länge des Balkens m
xmax,ymax=6,2.5  
#Slider abfragen
def update(val):
    x = sldX.val
    Fb=F*x/l
    Fa=F-Fb
    txtF.set(x=x,y=2.1)
    txtFa.set_text('$F_{A}$ = %.1f N' %Fa)
    txtFb.set_text('$F_{B}$ = %.1f N' %Fb)
    pfeilF.set_positions((x, 2),(x,1.0))
#Grafikbereich
fig, ax=plt.subplots(label="Auflagekräfte")
fig.subplots_adjust(left=0.12,bottom=0.18)
x=np.linspace(0,l,500)
ax.axis([-1,l+2,0,ymax])
#Balken
ax.plot([0,l],[1,1],'k-',lw=6)
#Vektoren
spitze = ArrowStyle.Simple(head_length=8,head_width=4)
pfeilF = FancyArrowPatch((2.5,2),(2.5,1.0),color='red',arrowstyle=spitze)
#Auflagekräfte
pfeilA = FancyArrowPatch((0,0),(0,1),color='red',arrowstyle=spitze)
pfeilB = FancyArrowPatch((l,0),(l,1),color='red',arrowstyle=spitze)
ax.add_patch(pfeilF)
ax.add_patch(pfeilA)
ax.add_patch(pfeilB)
#platzieren der Textelemente
txtFa=ax.text(0.1,0.5,'$F_{A}$ = %.1f N' %500)
txtFb=ax.text(5.1,0.5,'$F_{B}$ = %.1f N' %500)
txtF =ax.text(2.5,2.1, '$F$ = %.1f N' %F)
#Slider
xyX=fig.add_axes([0.09, 0.02, 0.82, 0.03])
sldX=Slider(xyX,'$x$ in m',0,5,valinit=2.5,valstep=0.1)
sldX.on_changed(update)
ax.set_axis_off() #ax.axis('off')
plt.show()

#Listing 2.4




