#sld_kraefte_addieren.py
import matplotlib.pyplot as plt
from matplotlib.patches import FancyArrowPatch,ArrowStyle
from matplotlib.widgets import Slider
#Slider abfragen
def update(val):
    x1 = sldX1.val
    y1 = sldY1.val
    x2 = sldX2.val
    y2 = sldY2.val
    pfeilX.set_positions((0, 0),(x1,y1))
    pfeilY.set_positions((0, 0),(x2,y2))
    pfeilZ.set_positions((0, 0),(x1+x2,y1+y2))
#Grafikbereich
fig, ax=plt.subplots(label="Addition von Kraftvektoren")
fig.subplots_adjust(left=0.12,bottom=0.3)
ax.axis([-20,20,-20,20])
ax.plot(0,0,'ko',markersize=8)
#Pfeile
spitze = ArrowStyle.Simple(head_length=10,head_width=6,tail_width=0.8)
pfeilX=FancyArrowPatch((0,0),(-10,10),color='red',arrowstyle=spitze)
pfeilY=FancyArrowPatch((0,0),(10,10),color='red',arrowstyle=spitze)
pfeilZ=FancyArrowPatch((0,0),(0,20),color='black',arrowstyle=spitze)
ax.add_patch(pfeilX)
ax.add_patch(pfeilY)
ax.add_patch(pfeilZ)
#Slider
xyX1=fig.add_axes([0.09, 0.17, 0.82, 0.03])
xyY1=fig.add_axes([0.09, 0.12, 0.82, 0.03])
xyX2=fig.add_axes([0.09, 0.07, 0.82, 0.03])
xyY2=fig.add_axes([0.09, 0.02, 0.82, 0.03])
sldX1=Slider(xyX1,'$F_{x1}$',-10,10,valinit=-10,valstep=0.1)
sldY1=Slider(xyY1,'$F_{y1}$',-10,10,valinit=10,valstep=0.1)
sldX2=Slider(xyX2,'$F_{x2}$',-10,10,valinit=10,valstep=0.1)
sldY2=Slider(xyY2,'$F_{y2}$',-10,10,valinit=10,valstep=0.1)
sldX1.on_changed(update)
sldY1.on_changed(update)
sldX2.on_changed(update)
sldY2.on_changed(update)
ax.set_aspect('equal')
ax.set(xlabel='$F_{x}$',ylabel='$F_{y}$')
ax.grid()
plt.show()

#Listing 2.1


