#sld_massenschwerpunkt2.py
from math import pi
import matplotlib.pyplot as plt
from matplotlib.patches import Rectangle,Circle,FancyArrowPatch,ArrowStyle
from matplotlib.widgets import Slider
rho=7.85 #Dichte von Stahl in kg/dm^3
l = 2    #Länge des Stabes in m
#
def massenschwerpunkt(l1,d1,d2):
    m1=rho*pi*(d1/2)**2*l1
    m2=rho*4/3*pi*(d2/2)**3
    xs = (m1*l1/2+m2*(l1+d2/2))/(m1+m2)
    return m1,m2,xs
#Slider abfragen
def update(val):
    d1 = 0.1*sldD1.val #cm in dm 
    d2 = 0.1*sldD2.val #cm in dm
    m1,m2,l1=massenschwerpunkt(10*l,d1,d2)
    xs=0.1*l1 #in m
    r=d2*1e-1
    txtM1.set_text('$m_{1}$ = %.1f kg' %m1)
    txtM2.set_text('$m_{2}$ = %.1f kg' %m2)
    txtXs.set_text('$x_{s}$ = %.2f m' %xs) #Schwerpunkt
    d1=d1*0.25
    pfeilA.set_positions((xs,-2*d1),(xs,-0.5*d1))#Stützpunkt
    stab.set_height(d1)
    stab.set_y(-d1/2)
    kugel.set_radius(r)
    return kugel,stab
#Grafikbereich
fig, ax=plt.subplots(figsize=(10,4),label="Massenschwerpunkt")
fig.subplots_adjust(left=0.12,bottom=0.18)
ax.axis([-0.1,1.2*l,-1.1*l,1.1*l])
#Massen
stab = Rectangle((0,-0.02),l,0.04,color='black')
kugel = Circle((l,0), radius=0.1,color='black')
ax.add_patch(stab)
ax.add_patch(kugel)
#Drehachse
spitzeA=ArrowStyle.Simple(head_length=20,head_width=20)
pfeilA = FancyArrowPatch((1.48,-0.1),(1.48,-0.02),color='red',arrowstyle=spitzeA)
ax.add_patch(pfeilA)
#platzieren der Textelemente
txtM1=ax.text(-0.1,0.3,'$m_{1}$ = %.1f kg' %4.9)
txtM2=ax.text(1.9,0.3,'$m_{2}$ = %.1f kg' %5.1)
txtXs=ax.text(-0.15,-0.3,'$x_{s}$ = %.2f m' %1.48)
#Slider
xyD1=fig.add_axes([0.09, 0.08, 0.82, 0.03])
xyD2=fig.add_axes([0.09, 0.02, 0.82, 0.03])
sldD1=Slider(xyD1,'$d_{1}$ in cm',1,2,valinit=2,valstep=0.01)
sldD2=Slider(xyD2,'$d_{2}$ in cm',5,10,valinit=10,valstep=0.01)
sldD1.on_changed(update)
sldD2.on_changed(update)
ax.axis('off')
ax.axis('equal')
plt.show()







