#abb_03_03.py
#Dehnung eines Stabes
import numpy as np
import matplotlib.pyplot as plt
A=100   #Querschnitt des Probstabes mm^2
l0=1000 #Länge des Probstabes in mm
E=200  #kN/mm^2
#Kraft
def kraft(deltaL):
    return E*A*deltaL/l0
#Dehnung
def dehnung(epsilon):
    return E*epsilon*1e3 
#Grafikbereich
fig,ax=plt.subplots(1,2)
x=np.linspace(0,5,200)
e=np.linspace(0,5e-3,200)
ax[0].set_xlim(0,5)
ax[1].set_xlim(0,5e-1)
ax[0].plot(x,kraft(x),'r-')
ax[1].plot(e*1e2,dehnung(e),'b-')
#Beschriftungen
ax[0].set_xlabel(r'$\Delta l$ in mm')
ax[0].set_ylabel('$F$ in kN')
ax[0].set_title('$l_0$ = %3.0f mm, $A$ = %3.0f $\mathrm{mm^2}$' %(l0,A))
ax[1].set_ylabel(r'$\sigma$ in $\mathrm{\frac{N}{mm^{2}}}$')
ax[1].set_xlabel(r'$\epsilon$ in %')
ax[1].set_title(r'$\sigma =f\left( \epsilon \right)$')
ax[0].grid();ax[1].grid()
fig.tight_layout()
# print(1000/5e-3) #Elastizitätsmodul
# print(100000*l0/(A*5))
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_03-NF003.svg")
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_03-NF003.pdf")
plt.show()
 
