#abb_03_13.py
#Biegemoment zweiseitig gelagerter Balken mit konstanter Streckenlast
import numpy as np
import matplotlib.pyplot as plt
#Daten
F=1000  #N
l=4     #Länge des Balkens in m
q0=F/l
#Streckenlast
def biegemoment(x):
    return -q0/2*x*(l-x)
#Grafikbereich
fig,ax=plt.subplots(figsize=(10,4))
x=np.linspace(0,l,1000)
ax.plot(x,biegemoment(x),'r-')
#Beschriftungen
ax.set_xlabel('$x$ in m')
ax.set_ylabel('$M_b$ in Nm')
ax.grid()
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_03-NF013.svg")
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_03-NF013.pdf")
plt.show()
 

