#L_03_06.py
'''
Simulation des Biegemoments für konstante Streckenlast
'''
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.patches import FancyArrowPatch,ArrowStyle
from matplotlib.widgets import Slider
#Daten des Balkens
l= 5    #Länge des Balkens m
#Biegemoment
def biegemoment(x,q):
    return -q/2*x*(l-x)
#Slider abfragen
def update(val):
    q0 = sldQ.val
    Mbmax=biegemoment(l/2,q0)
    txtMbmax.set_text('$M_{bmax}$ = %.1f Nm' %Mbmax)
    y.set_data(x,biegemoment(x,q0))
#Grafikbereich
fig, ax=plt.subplots(label="Biegemoment")
fig.subplots_adjust(left=0.12,bottom=0.18)
x=np.linspace(0,l,500)
ax.axis([0,l,-700,0])
y, = ax.plot(x,biegemoment(x,100),'r-',lw=1.5)
#platzieren der Textelemente
txtMbmax=ax.text(0.1,-650,'$M_{bmax}$ = %.1f Nm' %-312.5)
#Slider
xyQ=fig.add_axes([0.13, 0.02, 0.80, 0.03])
sldQ=Slider(xyQ,'$q_0$ in N/m',0,200,valinit=100,valstep=1)
sldQ.on_changed(update)
#Beschriftungen
ax.set_xlabel('$x$ in m')
ax.set_ylabel('$M_b$ in Nm')
ax.set_title('Biegemoment $M_{b}=f(x,q_{0})$')
plt.show()








