#L_03_07.py
'''
Biegelinie für einen einseitig eingespannten Balken
für Einzelast
'''
from sympy import *
F,Iy,E,l=symbols('F,Iy,E,l')
x = symbols('x')
w = Function('w')(x)
dgl=Eq(w.diff(x,2),-F*(l-x)/(E*Iy))
aL=dsolve(dgl)        #allgemeine Lösung der DGL
rb={                  #Randbedingungen
    w.subs(x,0):0,    #an der Befestigungsstelle kommt keine Biegung vor
    w.diff(x,1).subs(x,0):0, #an der Befestigungsstelle hat die Biegelinie keine Steigung 
    }                 
sL=dsolve(dgl,ics=rb) #spez. Lösung
rL=sL.rhs             #rechte Seite der Gleichung
wmax=rL.subs(x,l)     #maximale Durchbiegung w(l)
#Ausgaben
print("allgemeine Lösung\n",aL)
print("spezielle Lösung\n",sL)
print("rechte Seite der Gleichung\n w(x) =",rL)
print("wmax =",wmax)





