#plot_biegelinie.py
import numpy as np
import matplotlib.pyplot as plt
#Daten
F = 1e3  #Einzellast in N
l = 5    #Länge des Balkens m
q0 = F/l #Streckenlast in N/m
b = 0.05 #Breite in m
h = 0.1  #Höhe in m
E = 200e9 #N/m^2
#Flächenmoment 2. Grades
Iy=b*h**3/12 
#Biegelinie bei Einzellast
def biegelinie1(x):
    x=l/2-x
    return -F*l**3/(48*E*Iy) + F*np.abs(x)**3/(6*E*Iy)
#Biegelinie bei Streckenlast
def biegelinie2(x):
    return -l**3*q0*x/(24*E*Iy) + l*q0*x**3/(12*E*Iy) - q0*x**4/(24*E*Iy)
#Grafikbereich
fig,ax=plt.subplots(figsize=(10,4))
x=np.linspace(0,l,200)
ax.set_ylim(1.1e3*biegelinie1(l/2),0)
ax.plot(x,1e3*biegelinie1(x),'r-',lw=2,label='Einzellast')
ax.plot(x,1e3*biegelinie2(x),'b-.',lw=2,label='Streckenlast')
#Beschriftungen
ax.set_title('$F$ = %2.0f N\t$q_0$ = %2.0f N/m\t $b$ =%2.0f cm\t$h$ =%2.0f cm' %(F,q0,b*100,h*100))
ax.set_ylabel('$w$ in mm')
ax.set_xlabel('$x$ in m')
ax.legend()
plt.show()


