#sld_balken_biegung.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.patches import FancyArrowPatch,ArrowStyle
from matplotlib.widgets import Slider
#Daten des Balkens
qmax = 200 #N/m^2
b = 0.02   #Breite in m
h = 0.03   #Höhe in m
l = 5      #Länge des Balkens m
E=200e9    #N/m^2
Iy=b*h**3/12 #Flächenmoment 2.Grades
#Biegelinie
def biegung(x,q):
    return -q*(x**4/24-l*x**3/12+l**3*x/24)/(E*Iy)
#Biegemoment
def biegemoment(x,q):
    return q/2*x*(l-x)
#Slider abfragen
def update(val):
    q0 = sldQ.val
    F=q0*l
    Fa=Fb=F/2
    w=biegung(l/2,q0)*1e3 #Durchbiegung in mm umwandeln
    Mbmax=biegemoment(l/2,q0)
    sigma=Mbmax/Iy*h/2*1e-6 #Umwandlung in N/mm^2
    txtQ.set_text('$q_0$ = %.1f N/m' %q0)
    txtFa.set_text('$F_{a}$ = %.1f N' %Fa)
    txtFb.set_text('$F_{b}$ = %.1f N' %Fb)
    txtW.set_text('$w$ = %.0f mm' %w)
    txtMbmax.set_text('$M_{bmax}$ = %.1f Nm' %Mbmax)
    txtSig.set_text(r'$\sigma$ = %3.0f $\mathrm{\frac{N}{mm^{2}}}$' %sigma)
    biegelinie.set_data(x,biegung(x,q0))
#Grafikbereich
fig, ax=plt.subplots(label="Biegelinie für Streckenlast")
fig.subplots_adjust(left=0.12,bottom=0.18)
x=np.linspace(0,l,500)
ax.axis([-1,l+1,-2,2])
biegelinie, = ax.plot(x,biegung(x,100),'b-',lw=5)
#Auflagekräfte
ax.arrow(0,-1,0,1,width=0.03,length_includes_head=True,color='red')
ax.arrow(l,-1,0,1,width=0.03,length_includes_head=True,color='red')
#platzieren der Textelemente
txtFa=ax.text(0,-1.5,'$F_{a}$ = %.1f N' %250)
txtFb=ax.text(5,-1.5,'$F_{b}$ = %.1f N' %250)
txtQ =ax.text(2.2,1, '$q_0$ = %.1f N/m' %(qmax//2))
txtMbmax=ax.text(1.8,0.7,'$M_{bmax}$ = %.1f Nm' %312.5)
txtSig=ax.text(2.2,0.4, r'$\sigma$ = %.0f $\mathrm{\frac{N}{mm^{2}}}$' %104)
txtW =ax.text(2.2,-0.5, '$w$ = %.0f mm' %-90)
#Slider
xyQ=fig.add_axes([0.13, 0.02, 0.78, 0.03])
sldQ=Slider(xyQ,'$q_0$ in N/m',0,qmax,valinit=qmax//2,valstep=1)
sldQ.on_changed(update)
ax.set_title('$b$ =%2.0f cm\t$h$ =%2.0f cm' %(b*100,h*100))
ax.axis('off')
plt.show()









