#sld_biegemoment.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.patches import FancyArrowPatch,ArrowStyle
from matplotlib.widgets import Slider
#Daten
F0=500  #N
b= 0.04 #Breite in m
h= 0.08 #Höhe in m
l= 5   #Länge des Balkens m
E=200e9 #N/m^2
Mb=F0*l/4 #maximales Biegemoment
Iy=b*h**3/12 #Flächenmoment zweiten Grades
xmax,ymax=6,2
syF=2e-3 #Skaliereung für Pfeillänge
syM=1e-3 #Skaliereung für Biegemoment
#Slider abfragen
def update(val):
    F = sldF.val
    x=sldX.val
    Fb=F*x/l      #Auflagekraft B
    Fa=F*(l-x)/l  #Auflagekraft A
    if x<=l/2:
        Mb=F/2*x  #Biegemoment
    else:
        Mb=F/2*(l-x)
    sigma=Mb/Iy*h/2*1e-6 #mm^2
    txtF.set_text('$F$ = %.1f N' %F)
    txtF.set(x=x,y=syF*F)
    txtFa.set_text('$F_{a}$ = %.1f N' %Fa)
    txtFb.set_text('$F_{b}$ = %.1f N' %Fb)
    txtMb.set_text('$M_{b}$ = %.1f Nm' %Mb)
    txtSig.set_text(r'$\sigma$ = %.1f $\mathrm{\frac{N}{mm^{2}}}$' %sigma)
    pfeilF.set_positions((x,syF*F),(x,0))
    linieM1.set_data([0,x],[0,-Mb*syM])
    linieM2.set_data([l,x],[0,-Mb*syM])
#Grafikbereich
fig, ax=plt.subplots(label="Biegemoment")
fig.subplots_adjust(left=0.12,bottom=0.18)
x=np.linspace(0,l,500)
ax.axis([-1,l+1,-ymax,ymax])
ax.plot([0,l],[0,0],'k-',lw=5) #Balken
linieM1, = ax.plot([0,l/2],[0,-625*syM],'r-')
linieM2, = ax.plot([l,l/2],[0,-625*syM],'r-')
#Auflagekräfte
ax.arrow(0,-1,0,1,width=0.03,length_includes_head=True,color='red')
ax.arrow(l,-1,0,1,width=0.03,length_includes_head=True,color='red')
#Lastvektor
spitze = ArrowStyle.Simple(head_length=6,head_width=5)
pfeilF = FancyArrowPatch((l/2,syF*F0),(l/2,0),color='red',arrowstyle=spitze)
ax.add_patch(pfeilF)
#platzieren der Textelemente
txtFa=ax.text(-0.5,-1.5,'$F_{a}$ = %.1f N'%(F0/2))
txtFb=ax.text(4.5,-1.5, '$F_{b}$ = %.1f N'%(F0/2))
txtF =ax.text(2.5,1, '$F$ = %.1f N' %F0)
txtMb =ax.text(-0.6,1.8,'$M$ = %.1f Nm' %(F0*l/4))
txtSig=ax.text(-0.6,1.5, r'$\sigma$ = %.1f $\mathrm{\frac{N}{mm^{2}}}$' %14.6)
ax.set_title('$b$ = %0.1f cm \t $h$ = %.1f cm' %(b*100,h*100))
#Slider
xyX=fig.add_axes([0.09, 0.08, 0.82, 0.03])
sldX=Slider(xyX,'$x$ in m',0.05*l,0.95*l,valinit=l/2,valstep=0.05)
xyF=fig.add_axes([0.09, 0.02, 0.82, 0.03])
sldF=Slider(xyF,'$F$ in N',100,F0,valinit=F0,valstep=1)
sldX.on_changed(update)
sldF.on_changed(update)
ax.axis('off')
plt.show()

#Listing 3.7






