#sym_biegelinie2.py
from sympy import *
q0,Iy,E,l=symbols('q0,Iy,E,l')
x = symbols('x')
w = Function('w')(x)
dgl=Eq(w.diff(x,4),-q0/(E*Iy))
aL=dsolve(dgl)        #allgemeine Lösung der DGL
rb={                  #Randbedingungen
    w.subs(x,0):0,
    w.subs(x,l):0,
    w.diff(x,1).subs(x,l/2):0,
    w.diff(x,2).subs(x,l):0
    }                 
sL=dsolve(dgl,ics=rb) #spez. Lösung
rL=sL.rhs             #rechte Seite der Gleichung
wmax=rL.subs(x,l/2)   #Maximum der Durchbiegung
#Ausgaben
print("allgemeine Lösung\n",aL)
print("spezielle Lösung\n",sL)
print("rechte Seite der Gleichung\n w(x) =",rL)
print("wmax =",wmax)




