#sym_draht.py
from sympy import *
g,A,E,l,rho,m=symbols('g,A,E,l,rho,m')
z = symbols('z')
w = Function('w')(z)
F=m*g + rho*g*A*(l - z)
dgl=Eq(w.diff(z,1),F/(E*A))
aL=dsolve(dgl)        #allgemeine Lösung der DGL
rb={                  #Randbedingung
    w.subs(z,0):0
    }                 
sL=dsolve(dgl,ics=rb) #spez. Lösung
rL=sL.rhs             #rechte Seite der Gleichung
wmax=rL.subs(z,l)
#Ausgaben
print("allgemeine Lösung\n",aL)
print("spezielle Lösung\n",sL)
print("rechte Seite der Gleichung\n w(z) =",rL)
print("wmax =",wmax)

'''
Gabbert S. 136f
'''




