#abb_04_003.py
#Beschleunigung
import numpy as np
import matplotlib.pyplot as plt
#Daten
tmax=10 #s
a=10    #m/s
#Funktionsdefinition
def v(t):
    return a*t
#Grafikbereich
fig, ax = plt.subplots(label='Beschleungigte Bewegung')
t=np.linspace(0,tmax,100)
ax.plot(t,v(t),'r-')
ax.plot([2,6],[v(2),v(2)],'b--') #vertikal
ax.plot([6,6],[v(2),v(6)],'b--') #horizontal
ax.text(0.1,98,r'$v=a\cdot t$') #Formel
ax.text(4,14,r'$\Delta t$')
ax.text(6.2,36,r'$\Delta v$')
ax.set_xlabel('$t$ in s')
ax.set_ylabel('$v$ in m/s')
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_04-NF003.svg")
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_04-NF003.pdf")
plt.show()


