#abb_04_008.py
#Parameterdarstellung für verschiedene Abwurfwinkel
import numpy as np
import matplotlib.pyplot as plt
#Daten
v0=20
g=9.81
#Funktionsdefinition
def f(t,alpha):
    x=v0*np.cos(alpha)*t
    y=v0*np.sin(alpha)*t-g*t**2/2
    return x,y
#Grafikbereich
fig,ax=plt.subplots()
ax.axis([0,42,0,20])
for winkel in [15,30,45,60,75]:
    alpha=np.radians(winkel)
    tw=2*v0*np.sin(alpha)/g
    t=np.linspace(0,tw)
    x,y=f(t,alpha)
    ax.plot(x,y,label=str(winkel)+'°')
ax.legend()
ax.set(xlabel='$x$ in m',ylabel='$y$ in m')
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_04-NF008.svg")
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_04-NF008.pdf")
plt.show()

