#abb_04_014.py
#Kreisbewegung mit vier Geschwindigkeitsvektoren
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.patches import FancyArrowPatch,ArrowStyle
r=1
xmax=ymax=1.10 
#x,y-Werte
def kreis(phi,r):    
    x=r*np.cos(phi)
    y=r*np.sin(phi)
    return x,y
#Grafikbereich
fig, ax=plt.subplots(figsize=(5,5))
ax.axis([-xmax,xmax,-xmax,ymax])
phi=np.linspace(0,2*np.pi,500)
x,y=kreis(phi,1)
ax.plot(x,y,'k-',lw=0.8)#Kreis zeichnen
#Beschriftungen
ax.text(-0.48,1.06, '$v$')
ax.text(0.05,0.7, '$a_{r}$')
#Vektoren
vL=0.8*r
spitze = ArrowStyle.Simple(head_length=8,head_width=4)
#Geschwindigkeiten
#x,y,delt_x,delta_y
pfeilV1=FancyArrowPatch((0,r),(-vL,r),color='blue',arrowstyle=spitze)
pfeilV2=FancyArrowPatch((-r,0),(-r,-vL),color='blue',arrowstyle=spitze)
pfeilV3=FancyArrowPatch((0,-r),(vL,-r),color='blue',arrowstyle=spitze)
pfeilV4=FancyArrowPatch(( r,0),( r, vL),color='blue',arrowstyle=spitze)
#Beschleunigungen
pfeilA1=FancyArrowPatch((0,r),(0,0.4),color='red',arrowstyle=spitze)
pfeilA2=FancyArrowPatch((-r,0),(-0.4,0),color='red',arrowstyle=spitze)
pfeilA3=FancyArrowPatch((0,-r),(0,-0.4),color='red',arrowstyle=spitze)
pfeilA4=FancyArrowPatch((r,0),(0.4,0),color='red',arrowstyle=spitze)
#Gescheindigkeitspfeile einfügen
ax.add_patch(pfeilV1)
ax.add_patch(pfeilV2)
ax.add_patch(pfeilV3)
ax.add_patch(pfeilV4)
#Beschleunigungspfeile einfügen
ax.add_patch(pfeilA1)
ax.add_patch(pfeilA2)
ax.add_patch(pfeilA3)
ax.add_patch(pfeilA4)
#Mittelpunkt
ax.plot(0,0,'ro') 
#Massepunkte
ax.plot(0,r,'ko',markersize=10)
ax.plot(0,-r,'ko',markersize=10)
ax.plot(-r,0,'ko',markersize=10)
ax.plot(r,0,'ko',markersize=10)
ax.set_aspect('equal')
ax.axis('off')
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_04-NF014.svg")
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_04-NF014.pdf")
plt.show()




