#L_04_03.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider
from matplotlib.patches import FancyArrowPatch,ArrowStyle
a=10   #Beschleunigung in m/s^2
delta_t=1
t1=2
#Weg
def s(t):
    return a*t**2/2
#zentraler Differenzenquotient
def diff(t0,f,h=1e-4):
    return (f(t0+h)-f(t0-h))/(2*h)
#Slider abfragen
def update(val):
    t1 = sldV.val
    v=diff(t1,s) #Momentangeschwindigkeit 1. Ableitung
    t2,s2=t1+delta_t,v*delta_t + s(t1)
    Tangente.set_positions((t1,s(t1)),(t2,s2))
    punkt.set_data([t1],[s(t1)])  #Punkt
    txtV.set_text('v = %.2f m/s' %v)
#Grafikbereich
fig, ax = plt.subplots(label='Momentangeschwindigkeit')
fig.subplots_adjust(left=0.12,bottom=0.2)
ax.set_xlim(0,5)
ax.set_ylim(-0.25,125)
#Tangente
v=diff(t1,s)
Tangente = FancyArrowPatch((t1,v),
                         (t1+delta_t,s(t1)+v*delta_t),
                         color='red')
ax.add_patch(Tangente)
#Textausgaben
txtA=ax.text(0.05,118,r'$a = %.2f\ \frac{m}{s^{2}}$' %a) #Text
txtV=ax.text(0.05,108,'v = 20.00 m/s') #Text
t = np.linspace(0, 5, 100) 
ax.plot(t, s(t),'b-') #Weg
punkt, = ax.plot(t1,s(t1), 'or') #Punkt
#x-, y-Position, Laenge, Hoehe
xyV = fig.add_axes([0.1, 0.05, 0.8, 0.03])
sldV=Slider(xyV,'t',0.0,5.0,valinit=2,valstep=0.1)
sldV.on_changed(update)
#Beschriftungen
ax.set_title(r'$s=\frac{1}{2}\cdot a \cdot t^{2}$')
ax.set(xlabel='t in s',ylabel='s in m')
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_04-NF005.png")
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_04-NF005.svg")
# fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_04-NF005.pdf")
plt.show()



