#L04_08.py
import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import quad
#Daten
alpha=2.5 #Tangentialbeschleinigung
tmax=10 #s
#konstante Winkelbeschleunigung
def ac(t):
    return 0*t+alpha
#Winkelgeschwindigkeit
def w(t):
    return alpha*t 
#Winkel
def phi(t):
    return 1/2*alpha*t**2 
#Grafikbereich
fig, ax = plt.subplots(3,1,figsize=(6,8))
t=np.linspace(0,tmax)
#Wertebereich der x und y-Achsen
ax[0].axis([0,tmax,0,5])
ax[1].axis([0,tmax,0,30])
ax[2].axis([0,tmax,0,150])
#Funktionsdarstellung
ax[0].plot(t,ac(t))
ax[1].plot(t,w(t))
ax[2].plot(t,phi(t))
#Beschriftungen
ax[0].set(ylabel=r'$\alpha\  in\  \frac{rad}{s^{2}}$',title='Winkelbeschleunigung')
ax[1].set(ylabel=r'$\omega\  in\  \frac{rad}{s}$',title='Winkelgeschwindigkeit')
ax[2].set(xlabel='t in s',ylabel=r'$\varphi\  in\ rad$',title='Winkel')
#Abstände zwischen den Unterdiagrammen
fig.tight_layout()
plt.show()




# #Formeln
# ax[1].text(0.3,83,r'$\omega=\alpha \cdot t$',fontsize=12)
# ax[2].text(0.3,420,r'$\varphi=\frac{1}{2} \alpha\cdot t^{2}$',fontsize=12)